package gov.va.med.mhv.sm.admin.enums;

public enum ClinicianStatusEnum{

	INCOMPLETE (0L, "In complete"),
	INPROCESS (10L, "In process"),
	COMPLETE (20L, "Complete");
	
	private Long id;
	private String status;
	
	private ClinicianStatusEnum(Long id, String status){
		System.out.println("Constructor==>"+id);
		this.id = id;
		this.status = status;
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}

	public static ClinicianStatusEnum valueOf(Long value){
		System.out.println("ValueOf==>"+value);
		try{
			for(ClinicianStatusEnum f : ClinicianStatusEnum.values()){
				if(f.getId().equals(value))
					return f;
			}	
		}catch(Exception e){
			System.out.println("Error->ValueOf==>"+value);
		}
		
		/* none found; throw error */
		throw new RuntimeException("no clinician status type found");
	}

}
